/****************************************************************************
**
** Copyright (C) 2010  Aimone Davide realsportcars@hotmail.com
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#ifndef KEYBOARD_H
#define KEYBOARD_H

#include <QWidget>
#include "settingsmenu.h"
#include "qbuttongroup.h"
#include "threestatebutton.h"

class Keyboard : public QWidget
{
    Q_OBJECT
public:
    explicit Keyboard(QWidget *parent = 0);
    void updateSettingsMenu(int);
    SettingsMenu *m_settingsMenu;
    ThreeStateButton *m_btShift;
    ThreeStateButton *m_btSymbol;
    ThreeStateButton *m_btAccent;

    static const int MODIFIERS_NONE;
    static const int MODIFIERS_SHIFT;
    static const int MODIFIERS_SYM;
    static const int MODIFIERS_ACCENT;
//    static const int MODIFIERS_SHIFT_SYM;
//    static const int MODIFIERS_SHIFT_ACCENT;
//    static const int MODIFIERS_SYM_ACCENT;
//    static const int MODIFIERS_SHIFT_SYM_ACCENT;
    static const QString CAPITALIZATION_CHAR;
    static const QString MOVERIGHT;
    static const QString MOVELEFT;
    static const QString NEXTWORD;
    static const QString PREVWORD;
    static const QString DELETE;
    static const QString NEWLINE;
    static const QString SPACE;
    void setButtonsLabel();
    int m_nActiveModifiers;
    QButtonGroup *m_bgCharacters;
    void charButtonClicked(QString, Core::Keyboards);
    void changeInputModifiers(bool bActivated,int nModifiers);    
    int m_nkbType;
    void setLabelColor(Core::LabelColor nColorIdx);
    void prepareForFirstCharacter();

protected:
    Core::QWERTY_LAYOUT m_activeLayout;
    QString m_sLastInputChar;
    SettingsMenu::inputStyle m_nActiveStyle;


signals:
    void inputStyleChanged(int);
    void input(QString, Core::Keyboards,bool bUppercase = false);

public slots:
     void settingsChanged(int);
     void maiuscClicked();
 };

#endif // KEYBOARD_H
